<?php

get_header(); ?>
<!-- for posts -->
    <section class="blogs-banner" style="background-image: url(<?php the_field('blog_page_banner', 'option'); ?>);"><!-- BLOG -->
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="blog-banner-title">
                        <h1>
                            <?php the_field('blog_page_title', 'option'); ?>
                        </h1>
                    </div>
                </div><!-- col -->
            </div><!-- row -->
        </div><!-- container -->
    </section><!-- blog -->
    
        <!-- news-section -->
        <section class="news-section blog-grid sec-pad">
            <div class="container">
                <div class="row clearfix">

                    <?php
                            if(have_posts() ) :
                            while(have_posts() ) :the_post(); 
                         ?>

                    <div class="col-lg-4 col-md-6 col-sm-12 news-block">
                        <div class="news-block-one wow fadeInUp animated animated" data-wow-delay="00ms" data-wow-duration="1500ms">
                            <div class="inner-box">
                                <figure class="image-box">
                                    <?php the_post_thumbnail(); ?>
                                    <a href="<?php the_permalink(); ?>" class="link"><i class="fas fa-link"></i></a>
                                    <div class="category"><p><i class="far fa-folder"></i><?php echo the_category(' '); ?></p></div>
                                </figure>
                                <div class="lower-content">
                                    <div class="upper-box">
                                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                        <ul class="post-info clearfix">
                                            <li><i class="far fa-calendar"></i><?php echo get_the_date('F j, Y'); ?></li>
                                            <li><i class="far fa-user"></i><a href="index-2.html"><?php the_author(); ?></a></li>
                                        </ul>
                                        <?php echo force_balance_tags( html_entity_decode( wp_trim_words( htmlentities( get_the_content() ), 15, $more="..." ) ) ); ?>
                                    </div>
                                    <div class="lower-box clearfix">
                                        <div class="comment-box pull-left">
                                            <p><i class="far fa-comment-alt"></i><a href="index-2.html"><?php get_comments_number(); ?></a></p>
                                        </div>
                                        <div class="link-box pull-right">
                                            <a href="<?php the_permalink(); ?>"><span><?php the_field('read_more', 'option'); ?></span><i class="flaticon-login"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                        <?php
                            endwhile;
                            ?>
                            <div class="pagination-wrapper centred">
                            <ul class="pagination clearfix">
                                <?php the_posts_pagination( array(
                                    'mid_size'  => 2,
                                    'prev_text' => __( '<i class="fas fa-angle-left"></i>', 'textdomain' ),
                                    'next_text' => __( '<i class="fas fa-angle-right"></i>', 'textdomain' ),
                                ) ); ?>
                            </ul>
                        </div>
                        <?php 
                            else:
                                get_template_part('template-parts/content', 'none');
                            endif;
                            wp_reset_postdata();

                         ?> 

                </div>
            </div>
        </section>
        <!-- news-section end -->
<?php get_footer(); ?>
